<?php
header('Content-Type: application/json');

$config = require 'r2_config.php';

function getSigningKey($secretKey, $dateStamp, $region, $service) {
    $kDate = hash_hmac('sha256', $dateStamp, 'AWS4' . $secretKey, true);
    $kRegion = hash_hmac('sha256', $region ?: 'auto', $kDate, true);
    $kService = hash_hmac('sha256', $service, $kRegion, true);
    return hash_hmac('sha256', 'aws4_request', $kService, true);
}

if ($_SERVER["REQUEST_METHOD"] === "GET") {
    echo json_encode([
        "success" => true,
        "api_name" => "Upload API - Cloudflare R2",
        "version" => "1.0",
        "status" => "active"
    ]);
    exit;
}

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$uploadType = $_POST['upload_type'] ?? 'file';

if ($uploadType === 'url') {
    $url1 = $_POST['url1'] ?? '';
    $url2 = $_POST['url2'] ?? '';
    
    if (empty($url1) || empty($url2)) {
        echo json_encode(['error' => 'Vui lòng nhập đầy đủ 2 link ảnh']);
        exit;
    }
    
    if (!filter_var($url1, FILTER_VALIDATE_URL) || !filter_var($url2, FILTER_VALIDATE_URL)) {
        echo json_encode(['error' => 'URL không hợp lệ']);
        exit;
    }
    
    $uploadDir = __DIR__ . '/uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }
    
    $uniqueId = time() . '-' . uniqid();
    $dataFile = $uploadDir . $uniqueId . '.json';
    
    $imageData = [
        'id' => $uniqueId,
        'url1' => $url1,
        'url2' => $url2,
        'uploadType' => 'url',
        'uploadDate' => date('c')
    ];
    
    file_put_contents($dataFile, json_encode($imageData, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));
    
    echo json_encode([
        'success' => true,
        'image' => [
            'id' => $uniqueId,
            'filename' => 'URL Image',
            'url' => $url1,
            'negativeUrl' => $url2,
            'uploadDate' => $imageData['uploadDate']
        ]
    ]);
    exit;
}

// Upload bằng file
if (!isset($_FILES['image1']) || !isset($_FILES['image2'])) {
    echo json_encode(['error' => 'Vui lòng upload đầy đủ 2 ảnh']);
    exit;
}

$file1 = $_FILES['image1'];
$file2 = $_FILES['image2'];

if ($file1['error'] !== UPLOAD_ERR_OK || $file2['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['error' => 'Lỗi khi upload file']);
    exit;
}

$uniqueId = time() . '-' . uniqid();
$extension1 = pathinfo($file1['name'], PATHINFO_EXTENSION);
$extension2 = pathinfo($file2['name'], PATHINFO_EXTENSION);
$filename1 = 'albumud/' . $uniqueId . '_1.' . $extension1;
$filename2 = 'albumud/' . $uniqueId . '_2.' . $extension2;

// Upload file 1
$fileContent1 = file_get_contents($file1['tmp_name']);
$method = 'PUT';
$service = 's3';
$region = 'auto';
$host = parse_url($config['endpoint'], PHP_URL_HOST);
$canonicalUri1 = '/' . $config['bucket'] . '/' . $filename1;
$url1 = $config['endpoint'] . $canonicalUri1;
$dateTime = gmdate('Ymd\THis\Z');
$dateStamp = gmdate('Ymd');
$payloadHash1 = hash('sha256', $fileContent1);

$canonicalHeaders1 = 
    "host:$host\n" .
    "x-amz-content-sha256:$payloadHash1\n" .
    "x-amz-date:$dateTime\n";

$signedHeaders = "host;x-amz-content-sha256;x-amz-date";
$canonicalQueryString = "";

$canonicalRequest1 = 
    "$method\n" .
    "$canonicalUri1\n" .
    "$canonicalQueryString\n" .
    "$canonicalHeaders1\n" .
    "$signedHeaders\n" .
    "$payloadHash1";

$credentialScope = "$dateStamp/$region/$service/aws4_request";
$stringToSign1 = 
    "AWS4-HMAC-SHA256\n" .
    "$dateTime\n" .
    "$credentialScope\n" .
    hash('sha256', $canonicalRequest1);

$signingKey = getSigningKey($config['secret_access_key'], $dateStamp, $region, $service);
$signature1 = hash_hmac('sha256', $stringToSign1, $signingKey);

$authorizationHeader1 = 
    "AWS4-HMAC-SHA256 " .
    "Credential={$config['access_key_id']}/$credentialScope, " .
    "SignedHeaders=$signedHeaders, " .
    "Signature=$signature1";

$headers1 = [
    "Authorization: $authorizationHeader1",
    "x-amz-date: $dateTime",
    "x-amz-content-sha256: $payloadHash1",
    "Content-Type: {$file1['type']}"
];

$ch1 = curl_init($url1);
curl_setopt_array($ch1, [
    CURLOPT_CUSTOMREQUEST => "PUT",
    CURLOPT_POSTFIELDS => $fileContent1,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $headers1
]);

$response1 = curl_exec($ch1);
$status1 = curl_getinfo($ch1, CURLINFO_HTTP_CODE);
curl_close($ch1);

// Upload file 2
$fileContent2 = file_get_contents($file2['tmp_name']);
$canonicalUri2 = '/' . $config['bucket'] . '/' . $filename2;
$url2 = $config['endpoint'] . $canonicalUri2;
$payloadHash2 = hash('sha256', $fileContent2);

$canonicalHeaders2 = 
    "host:$host\n" .
    "x-amz-content-sha256:$payloadHash2\n" .
    "x-amz-date:$dateTime\n";

$canonicalRequest2 = 
    "$method\n" .
    "$canonicalUri2\n" .
    "$canonicalQueryString\n" .
    "$canonicalHeaders2\n" .
    "$signedHeaders\n" .
    "$payloadHash2";

$stringToSign2 = 
    "AWS4-HMAC-SHA256\n" .
    "$dateTime\n" .
    "$credentialScope\n" .
    hash('sha256', $canonicalRequest2);

$signature2 = hash_hmac('sha256', $stringToSign2, $signingKey);

$authorizationHeader2 = 
    "AWS4-HMAC-SHA256 " .
    "Credential={$config['access_key_id']}/$credentialScope, " .
    "SignedHeaders=$signedHeaders, " .
    "Signature=$signature2";

$headers2 = [
    "Authorization: $authorizationHeader2",
    "x-amz-date: $dateTime",
    "x-amz-content-sha256: $payloadHash2",
    "Content-Type: {$file2['type']}"
];

$ch2 = curl_init($url2);
curl_setopt_array($ch2, [
    CURLOPT_CUSTOMREQUEST => "PUT",
    CURLOPT_POSTFIELDS => $fileContent2,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $headers2
]);

$response2 = curl_exec($ch2);
$status2 = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
curl_close($ch2);

if ($status1 !== 200 || $status2 !== 200) {
    echo json_encode([
        "success" => false,
        "status1" => $status1,
        "status2" => $status2,
        "response1" => $response1,
        "response2" => $response2
    ]);
    exit;
}

// Map sang Public Domain
$r2Url1 = $config['public_domain'] . '/' . $filename1;
$r2Url2 = $config['public_domain'] . '/' . $filename2;

// Lưu thông tin
$uploadDir = __DIR__ . '/uploads/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$dataFile = $uploadDir . $uniqueId . '.json';
$imageData = [
    'id' => $uniqueId,
    'url1' => $r2Url1,
    'url2' => $r2Url2,
    'uploadType' => 'r2',
    'uploadDate' => date('c')
];

file_put_contents($dataFile, json_encode($imageData, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

echo json_encode([
    'success' => true,
    'image' => [
        'id' => $uniqueId,
        'filename' => $file1['name'],
        'url' => $r2Url1,
        'negativeUrl' => $r2Url2,
        'uploadDate' => $imageData['uploadDate']
    ]
]);
?>
