<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Album Ảnh Chuyên Nghiệp</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item active">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="cosplay_scraper.php" class="taskbar-item">
                    <i class="fas fa-download"></i> <span>Scraper</span>
                </a>
                <a href="bulk_scraper.php" class="taskbar-item">
                    <i class="fas fa-spider"></i> <span>Bulk</span>
                </a>
                <a href="import_json.php" class="taskbar-item">
                    <i class="fas fa-file-import"></i> <span>Import</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <header>
            <h1><i class="fas fa-images"></i> Album Ảnh Chuyên Nghiệp</h1>
            <p class="subtitle">Thư viện ảnh của bạn</p>
        </header>

        <div class="gallery-container">
            <div class="gallery-header">
                <h2><i class="fas fa-th"></i> Thư viện ảnh</h2>
                <div class="gallery-controls">
                    <button class="btn btn-secondary" id="refreshBtn">
                        <i class="fas fa-sync-alt"></i> Làm mới
                    </button>
                </div>
            </div>
            
            <div class="gallery" id="gallery">
                <div class="loading" id="loading">
                    <i class="fas fa-spinner fa-spin"></i> Đang tải...
                </div>
            </div>
        </div>
    </div>

    <!-- Modal xem ảnh lớn -->
    <div class="modal" id="imageModal">
        <span class="modal-close" id="modalClose">&times;</span>
        <img class="modal-content" id="modalImage">
        <div class="modal-nav">
            <button class="modal-btn prev" id="prevBtn"><i class="fas fa-chevron-left"></i></button>
            <button class="modal-btn next" id="nextBtn"><i class="fas fa-chevron-right"></i></button>
        </div>
    </div>

    <script src="public/js/app.js"></script>
</body>
</html>

