<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cosplay Scraper Tool - Album</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="public/css/albums.css">
    <style>
        .scraper-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .scraper-form {
            background: rgba(255, 255, 255, 0.95);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px;
        }
        .result-box {
            background: rgba(255, 255, 255, 0.95);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        }
        .json-preview {
            background: #f8f9fa;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 20px;
            max-height: 500px;
            overflow-y: auto;
            font-family: 'Courier New', monospace;
            font-size: 0.9em;
            white-space: pre-wrap;
            word-wrap: break-word;
        }
        .image-preview-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }
        .image-preview-item {
            border-radius: 8px;
            overflow: hidden;
            border: 2px solid #e9ecef;
        }
        .image-preview-item img {
            width: 100%;
            height: 150px;
            object-fit: cover;
        }
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }
        .info-item {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
        }
        .info-item label {
            display: block;
            font-weight: 600;
            color: #666;
            margin-bottom: 5px;
            font-size: 0.9em;
        }
        .info-item .value {
            color: #333;
            font-size: 1em;
        }
        .loading-spinner {
            text-align: center;
            padding: 40px;
        }
        .error-box {
            background: #fee;
            border: 2px solid #fcc;
            color: #c00;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
                <a href="cosplay_scraper.php" class="taskbar-item active">
                    <i class="fas fa-download"></i> <span>Scraper</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <header>
            <h1><i class="fas fa-download"></i> Cosplay Scraper Tool</h1>
            <p class="subtitle">Lấy thông tin từ cosplaytele.com và xuất JSON</p>
        </header>

        <div class="scraper-container">
            <div class="scraper-form">
                <form id="scraperForm">
                    <div class="form-group">
                        <label for="cosplayUrl">
                            <i class="fas fa-link"></i> URL Cosplaytele.com *
                        </label>
                        <input type="url" id="cosplayUrl" name="url" required 
                               placeholder="https://cosplaytele.com/fleurdelys/" 
                               class="form-control">
                        <small class="form-help">Nhập URL bài viết từ cosplaytele.com</small>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <i class="fas fa-folder"></i> Chọn Album
                        </label>
                        <select id="albumSelect" class="form-control">
                            <option value="">-- Chọn album để import --</option>
                        </select>
                        <small class="form-help">Chọn album để import post sau khi scrape</small>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Lấy Thông Tin
                    </button>
                </form>
            </div>

            <div id="resultBox" class="result-box" style="display: none;">
                <h2><i class="fas fa-info-circle"></i> Thông Tin Đã Lấy</h2>
                
                <div id="errorMessage" class="error-box" style="display: none;"></div>
                
                <div id="loadingSpinner" class="loading-spinner" style="display: none;">
                    <i class="fas fa-spinner fa-spin fa-3x"></i>
                    <p>Đang lấy thông tin...</p>
                </div>

                <div id="infoDisplay" style="display: none;">
                    <div class="info-grid" id="infoGrid"></div>
                    
                    <h3 style="margin-top: 30px;"><i class="fas fa-images"></i> Preview Ảnh</h3>
                    <div class="image-preview-grid" id="imagePreview"></div>
                    
                    <h3 style="margin-top: 30px;"><i class="fas fa-code"></i> JSON Output</h3>
                    <div class="json-preview" id="jsonOutput"></div>
                    
                    <div class="form-actions" style="margin-top: 20px;">
                        <button id="copyJsonBtn" class="btn btn-secondary">
                            <i class="fas fa-copy"></i> Copy JSON
                        </button>
                        <button id="downloadJsonBtn" class="btn btn-secondary">
                            <i class="fas fa-download"></i> Download JSON
                        </button>
                        <button id="importBtn" class="btn btn-primary">
                            <i class="fas fa-upload"></i> Import vào Album
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="public/js/cosplay_scraper.js"></script>
</body>
</html>
