<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Album Detail - Album Ảnh Chuyên Nghiệp</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="public/css/albums.css">
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <div id="albumHeader" class="album-header">
            <div class="loading" id="loadingHeader">
                <i class="fas fa-spinner fa-spin"></i> Đang tải...
            </div>
        </div>

        <div class="album-actions">
            <a href="create_post.php?album_id=" id="createPostBtn" class="btn btn-primary">
                <i class="fas fa-plus"></i> Tạo Post Mới
            </a>
            <button id="editAlbumBtn" class="btn btn-secondary" style="display: none;">
                <i class="fas fa-edit"></i> Chỉnh sửa Album
            </button>
        </div>

        <div class="posts-container">
            <div class="posts-grid" id="postsGrid">
                <div class="loading" id="loading">
                    <i class="fas fa-spinner fa-spin"></i> Đang tải posts...
                </div>
            </div>
        </div>
    </div>

    <!-- Modal xem post -->
    <div class="modal" id="postModal">
        <span class="modal-close" id="modalClose">&times;</span>
        <div class="modal-content-post" id="modalPostContent">
            <!-- Post content sẽ được load vào đây -->
        </div>
    </div>

    <script>
        const albumId = new URLSearchParams(window.location.search).get('id');
        if (!albumId) {
            window.location.href = 'albums.php';
        }
    </script>
    <script src="public/js/album_detail.js"></script>
</body>
</html>
