# Hướng dẫn cài đặt Cloudflare R2

## Bước 1: Cấu hình R2

File `r2_config.php` đã được tạo với thông tin của bạn. Kiểm tra lại các thông tin:

- `account_id`: Account ID của Cloudflare
- `access_key_id`: Access Key ID
- `secret_access_key`: Secret Access Key
- `bucket`: Tên bucket R2
- `endpoint`: Endpoint URL (đã được cấu hình tự động)
- `custom_domain`: (Tùy chọn) Nếu bạn có custom domain cho bucket public

## Bước 2: Cấu hình Custom Domain (Tùy chọn - Khuyến nghị)

Để có URL công khai vĩnh viễn, bạn nên:

1. Tạo custom domain trong Cloudflare R2 dashboard
2. Cấu hình bucket là public
3. Thêm custom domain vào `r2_config.php`:
   ```php
   'custom_domain' => 'https://cdn.yourdomain.com',
   ```

Nếu không có custom domain, hệ thống sẽ sử dụng endpoint trực tiếp (bucket phải public).

## Bước 3: Kiểm tra

Upload ảnh và kiểm tra xem URL trả về có đúng không.

## Lưu ý

- **Không cần cài đặt composer hoặc bất kỳ thư viện nào** - Code sử dụng curl trực tiếp
- Đảm bảo PHP có extension `curl` được bật
- Đảm bảo bucket R2 đã được tạo và có quyền truy cập
- Nếu sử dụng custom domain, đảm bảo bucket được set là public
- File sẽ được lưu trong folder `albumud/` trên R2

