// DOM Elements
const albumForm = document.getElementById('albumForm');
const albumThumbnail = document.getElementById('albumThumbnail');
const thumbnailPreview = document.getElementById('thumbnailPreview');

// Initialize
document.addEventListener('DOMContentLoaded', () => {
    setupEventListeners();
});

// Event Listeners
function setupEventListeners() {
    albumForm.addEventListener('submit', handleSubmit);
    
    // Preview thumbnail when URL is entered
    albumThumbnail.addEventListener('input', () => {
        const url = albumThumbnail.value.trim();
        if (url) {
            try {
                new URL(url);
                thumbnailPreview.innerHTML = `<img src="${url}" alt="Thumbnail preview" onerror="this.parentElement.innerHTML=''; this.parentElement.classList.remove('has-image');">`;
                thumbnailPreview.classList.add('has-image');
            } catch (e) {
                thumbnailPreview.innerHTML = '';
                thumbnailPreview.classList.remove('has-image');
            }
        } else {
            thumbnailPreview.innerHTML = '';
            thumbnailPreview.classList.remove('has-image');
        }
    });
}

// Handle form submission
async function handleSubmit(e) {
    e.preventDefault();
    
    const formData = {
        title: document.getElementById('albumTitle').value.trim(),
        description: document.getElementById('albumDescription').value.trim(),
        thumbnail: albumThumbnail.value.trim(),
        category: document.getElementById('albumCategory').value.trim()
    };
    
    if (!formData.title) {
        alert('Vui lòng nhập tiêu đề album!');
        return;
    }
    
    try {
        const response = await fetch('albums_api.php?action=create_album', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(formData)
        });
        
        const result = await response.json();
        
        if (result.success) {
            alert('Tạo album thành công!');
            window.location.href = `album_detail.php?id=${result.album.id}`;
        } else {
            alert('Lỗi: ' + (result.error || 'Không thể tạo album'));
        }
    } catch (error) {
        console.error('Create album error:', error);
        alert('Lỗi khi tạo album');
    }
}
