<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Import JSON - Album</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="public/css/albums.css">
    <style>
        .import-container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 20px;
        }
        .json-input-area {
            width: 100%;
            min-height: 400px;
            font-family: 'Courier New', monospace;
            font-size: 0.9em;
            padding: 15px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            resize: vertical;
        }
        .json-input-area:focus {
            outline: none;
            border-color: #FF9AA2;
            box-shadow: 0 0 0 3px rgba(255, 154, 162, 0.2);
        }
        .preview-section {
            margin-top: 30px;
            background: rgba(255, 255, 255, 0.95);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
                <a href="cosplay_scraper.php" class="taskbar-item">
                    <i class="fas fa-download"></i> <span>Scraper</span>
                </a>
                <a href="import_json.php" class="taskbar-item active">
                    <i class="fas fa-file-import"></i> <span>Import JSON</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <header>
            <h1><i class="fas fa-file-import"></i> Import JSON</h1>
            <p class="subtitle">Import post từ JSON file hoặc paste JSON trực tiếp</p>
        </header>

        <div class="import-container">
            <form id="importForm" class="album-form">
                <div class="form-group">
                    <label>
                        <i class="fas fa-folder"></i> Chọn Album *
                    </label>
                    <select id="albumSelect" class="form-control" required>
                        <option value="">-- Chọn album --</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-code"></i> JSON Data *
                    </label>
                    <textarea id="jsonInput" class="json-input-area" required 
                              placeholder='Paste JSON data here...&#10;Example:&#10;{&#10;  "title": "Post Title",&#10;  "cosplayer": "Cosplayer Name",&#10;  "character": "Character Name",&#10;  "images": ["https://..."],&#10;  ...&#10;}'></textarea>
                    <small class="form-help">Paste JSON data hoặc upload JSON file</small>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-file"></i> Hoặc Upload JSON File
                    </label>
                    <input type="file" id="jsonFile" accept=".json" class="form-control">
                    <small class="form-help">Chọn file JSON để import</small>
                </div>

                <div class="form-actions">
                    <button type="button" id="previewBtn" class="btn btn-secondary">
                        <i class="fas fa-eye"></i> Preview
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Import
                    </button>
                    <button type="button" id="clearBtn" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Clear
                    </button>
                </div>
            </form>

            <div id="previewSection" class="preview-section" style="display: none;">
                <h2><i class="fas fa-eye"></i> Preview</h2>
                <div id="previewContent"></div>
            </div>
        </div>
    </div>

    <script src="public/js/import_json.js"></script>
</body>
</html>
