<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Backup System - Album</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .backup-container {
            max-width: 1000px;
            margin: 50px auto;
            padding: 20px;
        }
        .backup-header {
            text-align: center;
            color: white;
            margin-bottom: 30px;
        }
        .backup-card {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 20px;
            backdrop-filter: blur(10px);
        }
        .backup-card h3 {
            color: white;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .backup-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: transform 0.2s;
            display: inline-flex;
            align-items: center;
            gap: 10px;
        }
        .backup-btn:hover {
            transform: translateY(-2px);
        }
        .backup-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        .backup-list {
            margin-top: 20px;
        }
        .backup-item {
            background: rgba(255, 255, 255, 0.05);
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .backup-item-info {
            flex: 1;
        }
        .backup-item-name {
            color: white;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .backup-item-details {
            color: rgba(255, 255, 255, 0.7);
            font-size: 14px;
        }
        .backup-item-actions {
            display: flex;
            gap: 10px;
        }
        .btn-action {
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            transition: opacity 0.2s;
        }
        .btn-download {
            background: #4CAF50;
            color: white;
        }
        .btn-delete {
            background: #f44336;
            color: white;
        }
        .btn-action:hover {
            opacity: 0.8;
        }
        .progress-bar {
            width: 100%;
            height: 6px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 3px;
            overflow: hidden;
            margin-top: 10px;
            display: none;
        }
        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #667eea, #764ba2);
            width: 0%;
            transition: width 0.3s;
        }
        .empty-state {
            text-align: center;
            color: rgba(255, 255, 255, 0.5);
            padding: 40px;
        }
    </style>
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Album</span>
                </a>
                <a href="admin.php" class="taskbar-item">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
                <a href="backup_page.php" class="taskbar-item active">
                    <i class="fas fa-database"></i> <span>Backup</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="backup-container">
            <div class="backup-header">
                <h1><i class="fas fa-database"></i> Backup System</h1>
                <p class="subtitle">Sao lưu website và dữ liệu ảnh</p>
            </div>

            <div class="backup-card">
                <h3><i class="fas fa-cloud-upload-alt"></i> Tạo Backup</h3>
                <p style="color: rgba(255,255,255,0.8); margin-bottom: 15px;">
                    Backup sẽ bao gồm: Tất cả file PHP, thư mục uploads (dữ liệu ảnh), và file cấu hình.
                </p>
                <button class="backup-btn" id="createBackupBtn" onclick="createBackup()">
                    <i class="fas fa-download"></i> Tạo Backup Ngay
                </button>
                <div class="progress-bar" id="backupProgress">
                    <div class="progress-fill" id="progressFill"></div>
                </div>
            </div>

            <div class="backup-card">
                <h3><i class="fas fa-history"></i> Danh Sách Backup</h3>
                <div class="backup-list" id="backupList">
                    <div class="empty-state">
                        <i class="fas fa-spinner fa-spin"></i> Đang tải...
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        let isBackingUp = false;

        // Load danh sách backup khi trang load
        document.addEventListener('DOMContentLoaded', () => {
            loadBackups();
        });

        async function createBackup() {
            if (isBackingUp) return;
            
            isBackingUp = true;
            const btn = document.getElementById('createBackupBtn');
            const progressBar = document.getElementById('backupProgress');
            const progressFill = document.getElementById('progressFill');
            
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Đang tạo backup...';
            progressBar.style.display = 'block';
            progressFill.style.width = '0%';
            
            try {
                // Simulate progress
                let progress = 0;
                const progressInterval = setInterval(() => {
                    progress += 10;
                    if (progress <= 90) {
                        progressFill.style.width = progress + '%';
                    }
                }, 500);
                
                const response = await fetch('backup.php?action=backup');
                const result = await response.json();
                
                clearInterval(progressInterval);
                progressFill.style.width = '100%';
                
                if (result.success) {
                    alert('Backup thành công!\nFile: ' + result.backup_file + '\nKích thước: ' + result.backup_size);
                    loadBackups();
                } else {
                    alert('Lỗi: ' + (result.error || 'Không thể tạo backup'));
                }
            } catch (error) {
                console.error('Backup error:', error);
                alert('Lỗi khi tạo backup: ' + error.message);
            } finally {
                isBackingUp = false;
                btn.disabled = false;
                btn.innerHTML = '<i class="fas fa-download"></i> Tạo Backup Ngay';
                setTimeout(() => {
                    progressBar.style.display = 'none';
                    progressFill.style.width = '0%';
                }, 1000);
            }
        }

        async function loadBackups() {
            try {
                const response = await fetch('backup.php?action=list');
                const result = await response.json();
                
                const backupList = document.getElementById('backupList');
                
                if (result.success && result.backups.length > 0) {
                    backupList.innerHTML = result.backups.map(backup => `
                        <div class="backup-item">
                            <div class="backup-item-info">
                                <div class="backup-item-name">
                                    <i class="fas fa-file-archive"></i> ${backup.filename}
                                </div>
                                <div class="backup-item-details">
                                    Kích thước: ${backup.size} | Ngày tạo: ${backup.date}
                                </div>
                            </div>
                            <div class="backup-item-actions">
                                <button class="btn-action btn-download" onclick="downloadBackup('${backup.filename}')">
                                    <i class="fas fa-download"></i> Tải về
                                </button>
                                <button class="btn-action btn-delete" onclick="deleteBackup('${backup.filename}')">
                                    <i class="fas fa-trash"></i> Xóa
                                </button>
                            </div>
                        </div>
                    `).join('');
                } else {
                    backupList.innerHTML = '<div class="empty-state">Chưa có backup nào</div>';
                }
            } catch (error) {
                console.error('Load backups error:', error);
                document.getElementById('backupList').innerHTML = 
                    '<div class="empty-state">Lỗi khi tải danh sách backup</div>';
            }
        }

        function downloadBackup(filename) {
            window.location.href = 'backup.php?action=download&file=' + encodeURIComponent(filename);
        }

        async function deleteBackup(filename) {
            if (!confirm('Bạn có chắc muốn xóa backup này?')) {
                return;
            }
            
            try {
                const response = await fetch('backup.php?action=delete&file=' + encodeURIComponent(filename));
                const result = await response.json();
                
                if (result.success) {
                    alert('Đã xóa backup thành công');
                    loadBackups();
                } else {
                    alert('Lỗi: ' + (result.error || 'Không thể xóa backup'));
                }
            } catch (error) {
                console.error('Delete backup error:', error);
                alert('Lỗi khi xóa backup: ' + error.message);
            }
        }
    </script>
</body>
</html>

