<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Upload Ảnh</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .admin-container {
            max-width: 900px;
            margin: 50px auto;
            padding: 20px;
        }
        .admin-header {
            text-align: center;
            color: white;
            margin-bottom: 30px;
        }
        .admin-header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
    </style>
</head>
<body>
    <!-- Taskbar Navigation -->
    <nav class="taskbar">
        <div class="taskbar-container">
            <div class="taskbar-logo">
                <i class="fas fa-images"></i> Album
            </div>
            <div class="taskbar-menu">
                <a href="index.php" class="taskbar-item">
                    <i class="fas fa-home"></i> <span>Home</span>
                </a>
                <a href="albums.php" class="taskbar-item">
                    <i class="fas fa-folder"></i> <span>Albums</span>
                </a>
                <a href="cosplay_scraper.php" class="taskbar-item">
                    <i class="fas fa-download"></i> <span>Scraper</span>
                </a>
                <a href="bulk_scraper.php" class="taskbar-item">
                    <i class="fas fa-spider"></i> <span>Bulk</span>
                </a>
                <a href="import_json.php" class="taskbar-item">
                    <i class="fas fa-file-import"></i> <span>Import</span>
                </a>
                <a href="admin.php" class="taskbar-item active">
                    <i class="fas fa-user-shield"></i> <span>Admin</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="admin-container">
            <div class="admin-header">
                <h1><i class="fas fa-user-shield"></i> Admin Panel</h1>
                <p class="subtitle">Quản lý và Upload Ảnh</p>
            </div>

            <div class="upload-section">
                <div class="upload-tabs">
                    <button class="tab-btn active" data-tab="file">
                        <i class="fas fa-file-upload"></i> Upload File
                    </button>
                    <button class="tab-btn" data-tab="url">
                        <i class="fas fa-link"></i> Upload bằng Link
                    </button>
                </div>

                <!-- Tab Upload File -->
                <div class="upload-tab-content active" id="fileTab">
                    <div class="upload-form">
                        <div class="upload-group">
                            <label class="upload-label">
                                <i class="fas fa-images"></i> Chọn nhiều cặp ảnh (Ảnh gốc và Ảnh khi bấm mắt)
                            </label>
                            <div class="upload-box" id="uploadBoxMultiple">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <p>Kéo thả nhiều ảnh vào đây hoặc click để chọn</p>
                                <p style="font-size: 0.9em; color: #999; margin-top: 10px;">
                                    Chọn số lượng ảnh chẵn (2, 4, 6, ...). Ảnh lẻ sẽ là ảnh gốc, ảnh chẵn sẽ là ảnh khi bấm mắt
                                </p>
                                <input type="file" id="fileInputMultiple" accept="image/*" multiple>
                            </div>
                            <div id="previewMultiple" class="preview-multiple"></div>
                        </div>
                        
                        <button class="btn btn-primary" id="uploadBtn" disabled>
                            <i class="fas fa-upload"></i> Upload Tất Cả Ảnh lên Cloudflare R2
                        </button>
                    </div>
                </div>

                <!-- Tab Upload URL -->
                <div class="upload-tab-content" id="urlTab">
                    <div class="upload-form">
                        <div class="upload-group">
                            <label class="upload-label">
                                <i class="fas fa-image"></i> Link ảnh đầu (Ảnh gốc)
                            </label>
                            <input type="url" id="urlInput1" class="url-input" placeholder="https://example.com/image1.jpg">
                            <div class="preview-box" id="previewUrl1"></div>
                        </div>
                        
                        <div class="upload-group">
                            <label class="upload-label">
                                <i class="fas fa-eye"></i> Link ảnh khi bấm mắt
                            </label>
                            <input type="url" id="urlInput2" class="url-input" placeholder="https://example.com/image2.jpg">
                            <div class="preview-box" id="previewUrl2"></div>
                        </div>
                        
                        <button class="btn btn-primary" id="uploadUrlBtn">
                            <i class="fas fa-link"></i> Thêm Ảnh từ Link
                        </button>
                    </div>
                </div>

                <div class="upload-progress" id="uploadProgress" style="display: none;">
                    <div class="progress-bar">
                        <div class="progress-fill" id="progressFill"></div>
                    </div>
                    <span id="progressText">0%</span>
                </div>
            </div>
        </div>
    </div>

    <script src="public/js/upload.js"></script>
</body>
</html>

